/******************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audiomanager.cpp
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audiomanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
*******************************************************************************/

/*******************************************************************************
                        Includes
*******************************************************************************/
/* Include message framework (AMT, msgfw) */
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
/* Include AudioRoute Manager FI interface */
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_SERVICEINFO
#include "midw_fi_if.h"
#include "amcontrol_clienthandler_fc_audiomanager.h"
#include "CAmControlSenderBase.h"
#include "shared/CAmDltWrapper.h"
#include "cca_if.h"

/*******************************************************************************
                  Specific defines for this component
*******************************************************************************/
DLT_DECLARE_CONTEXT(ClientFCAudioMgr)

/*******************************************************************************
                  Message map for FunctionIDs to be handled
*******************************************************************************/
BEGIN_MSG_MAP(amcontrol_clienthandler_fc_audiomanager, inc_fi_handler)
   //Properties
   ON_MESSAGE(MIDW_MASCFFI_C_U16_VOLUME, vOnVolumeStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_BASS, vOnBassStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_TREBLE, vOnTrebleStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnMidRangeStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_LOUDNESS, vOnLoudnessStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_BALANCE, vOnBalanceStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_FADER, vOnFaderStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION, vOnDynamicCompressionStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_EQUALISERPRESET, vOnEquPresetStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_GALA, vOnSpeedDepVolumeStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS, vOnMicConnectionStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnMicLevelStatus);
   ON_MESSAGE(MIDW_MASCFFI_C_U16_OPTIMIZATION, vOnSoundOptimizationStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnSoundRoomEffectStatus);
   ON_MESSAGE(MIDW_MASCFFI_C_U16_AUXINLEVEL, vOnLevelAuxInStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_BEEPSTATUS, vOnLevelBeepStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnLevelCenterStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnLevelSubWooferStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnSettingSurroundStatus)
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_MIDRANGE, vOnAudioModeStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS, vOnVolumeModeStatus)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS, vOnFaderActiveStatus)

   //Method results
   //ON_MESSAGE(MIDW_MASCFFI_C_U16_VOLUME, vOnVolume)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_VOLUMEMODE, vOnVolumeMode)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_MUTE, vOnMute)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_BEEP, vOnBeep)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE, vOnAmpDeviceAudRoute)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_AUDIOSOURCE, vOnAudioSource)
   ON_MESSAGE(MIDW_MASCFFI_C_U16_PERFORMONVOLUMELIMIT, vOnPerformVolLimit)
END_MSG_MAP()

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audiomanager
 *DESCRIPTION  : constructor for class amcontrol_clienthandler_fc_audiomanager
 *PARAMETER    : am::IAmRoutingReceiverShadow*
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audiomanager::amcontrol_clienthandler_fc_audiomanager(CAmControlSenderBase* pControlSenderBase,am::IAmControlReceiverShadow* pControlReceiver)
   : m_pControlSenderBase(pControlSenderBase),m_pControlReceiverShadowInterface(pControlReceiver),inc_fi_handler(
                          CCA_C_U16_APP_AUDIO                     // Application Id
               , MIDW_MASCFFI_C_U16_SERVICE_ID              // Service Id
               , MIDW_MASCFFI_C_U16_SERVICE_MAJORVERSION    // MajorVersion of Service
               , MIDW_MASCFFI_C_U16_SERVICE_MINORVERSION    // MinorVersion of Service
               )
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered in constructor amcontrol_clienthandler_fc_audiomanager()");
   CAmDltWrapper::instance()->registerContext(ClientFCAudioMgr, "CLAM", "ClientHandler for FCAudioManager");
   m_bSeviceAvailable = false;
   bRegisterForFID(MIDW_MASCFFI_C_U16_VOLUME);
   //bRegisterForFID(MIDW_MASCFFI_C_U16_VOLUMEMODE);
   //bRegisterForFID(MIDW_MASCFFI_C_U16_MUTE);
   bRegisterForFID(MIDW_MASCFFI_C_U16_BASS);
   bRegisterForFID(MIDW_MASCFFI_C_U16_TREBLE);
   bRegisterForFID(MIDW_MASCFFI_C_U16_MIDRANGE);

   bRegisterForFID(MIDW_MASCFFI_C_U16_LOUDNESS);
   bRegisterForFID(MIDW_MASCFFI_C_U16_BALANCE);
   bRegisterForFID(MIDW_MASCFFI_C_U16_FADER);
   bRegisterForFID(MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION);
   bRegisterForFID(MIDW_MASCFFI_C_U16_EQUALISERPRESET);
   bRegisterForFID(MIDW_MASCFFI_C_U16_GALA);
   bRegisterForFID(MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS);
   bRegisterForFID(MIDW_MASCFFI_C_U16_OPTIMIZATION);
   bRegisterForFID(MIDW_MASCFFI_C_U16_AUXINLEVEL);
   bRegisterForFID(MIDW_MASCFFI_C_U16_BEEPSTATUS);
   bRegisterForFID(MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS);
   bRegisterForFID(MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS);
}

/************************************************************************
 *FUNCTION     : amcontrol_clienthandler_fc_audiomanager
 *DESCRIPTION  : desructor for class amcontrol_clienthandler_fc_audiomanager
 *PARAMETER    : void
 *RETURN VALUE : none
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
amcontrol_clienthandler_fc_audiomanager::~amcontrol_clienthandler_fc_audiomanager(void)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered in ~amcontrol_clienthandler_fc_audiomanager");
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_VOLUME);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_BASS);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_TREBLE);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_MIDRANGE);

   bUnRegisterForFID(MIDW_MASCFFI_C_U16_LOUDNESS);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_BALANCE);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_FADER);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_EQUALISERPRESET);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_GALA);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_MICROPHONECONNECTIONSTATUS);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_OPTIMIZATION);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_AUXINLEVEL);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_BEEPSTATUS);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_VOLUMEMODESTATUS);
   bUnRegisterForFID(MIDW_MASCFFI_C_U16_FADERACTIVATIONSTATUS);
}

/************************************************************************
 *FUNCTION     : vOnVolume
 *DESCRIPTION  : callback for property Volume
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnVolumeStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus Called. ");

   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus->methodResult received. ");
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus->Status  received,opcode:AMT_C_U8_CCAMSG_OPCODE_STATUS");

            midw_mascffi_tclMsgVolumeStatus oVolumeMethodStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oVolumeMethodStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus received,VolumeMode:",oVolumeMethodStatus.VolumeMode.enType,
               ",Resource:",oVolumeMethodStatus.Resource.enType);
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus received,Channel:",oVolumeMethodStatus.Channel.enType,
               ",Volume:",oVolumeMethodStatus.Volume,",Source:",oVolumeMethodStatus.Source.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_VOLUME == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus->Status  received,Ignoring Volume Response");
            }
            break;
         }
      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus,opcode AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
      default:
         break;
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeStatus:poMessage == OSAL_NULL");
   }

}

/************************************************************************
 *FUNCTION     : vOnVolumeMode
 *DESCRIPTION  : callback for property VolumeMode
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnVolumeMode(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnVolumeMode");

   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode,opcode : AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
            midw_mascffi_tclMsgVolumeModeMethodResult oVolumeModeMethodResult;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oVolumeModeMethodResult);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode ,ServiceStatus:",oVolumeModeMethodResult.ServiceStatus.enType);

            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode,opcode : AMT_C_U8_CCAMSG_OPCODE_STATUS");
            midw_mascffi_tclMsgVolumeModeStatusStatus oVolumeModeStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oVolumeModeStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode received,VolumeMode:",oVolumeModeStatus.VolumeMode.enType,
               ",Resource:",oVolumeModeStatus.Resource.enType,",Channel:",oVolumeModeStatus.Channel.enType);

            break;
         }
      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode,opcode : AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
      default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeMode,opcode : Unknown");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnVolumeMode");
   }

}

/************************************************************************
 *FUNCTION     : vOnMute
 *DESCRIPTION  : callback for property Mute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnMute(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnMute");

   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnMute,opcode : AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
            midw_mascffi_tclMsgMuteMethodResult oMuteMethodResult;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oMuteMethodResult);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMute received,Requester:",oMuteMethodResult.Requester.enType,
               ",Resource:",oMuteMethodResult.Resource.enType,",State",oMuteMethodResult.State.enType,
               ",Channel",oMuteMethodResult.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MUTE_DEMUTE == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMute->Status  received,Inserting Mute/demute Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);

            }else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMute->Status  received,Ignoring Mute/demute Response...");
            }
            break;
         }
      case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnMute,opcode : AMT_C_U8_CCAMSG_OPCODE_STATUS");
            break;
         }
      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnMute,opcode : AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
      default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnMute,opcode : unknown");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMute,poMessage == OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnAmpDeviceAudRoute
 *DESCRIPTION  : callback for method AmpDeviceAudRoute
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnAmpDeviceAudRoute(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnAmpDeviceAudRoute");
   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAmpDeviceAudRoute,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");
            midw_mascffi_tclMsgAmpDeviceAudioRouteMethodResult oAmpDevAudRouteMethodResult;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oAmpDevAudRouteMethodResult);
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAmpDeviceAudRoute received,ServiceStatus:",oAmpDevAudRouteMethodResult.ServiceStatus.enType);
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAmpDeviceAudRoute,received with AMT_C_U8_CCAMSG_OPCODE_ERROR opcodes ");
            break;
         }
      default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAmpDeviceAudRoute,received with unknown opcodes ");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAmpDeviceAudRoute,poMessage == OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnAudioSource
 *DESCRIPTION  : callback for method AudioSource
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
 *************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnAudioSource(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnAudioSource");
   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAudioSource,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");
            midw_mascffi_tclMsgAudioSourceMethodResult oAudioSrcMethodResult;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oAudioSrcMethodResult);
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAudioSource->vOnAudioSource received,ServiceStatus:",oAudioSrcMethodResult.ServiceStatus.enType);
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAudioSource,received with AMT_C_U8_CCAMSG_OPCODE_ERROR opcodes ");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAudioSource,received with unknown opcodes ");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnAudioSource,poMessage == OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnPerformVolLimit
 *DESCRIPTION  : callback for method status PerformVolLimit
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *22.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnPerformVolLimit(amt_tclServiceData* poMessage)
{
  log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnPerformVolLimit");
  if ( poMessage != OSAL_NULL )
  {
    switch(poMessage->u8GetOpCode())
    {
     //You can add multiple cases for all the opcodes that you are interested in
     case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
     {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnPerformVolLimit,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");
      break;
     }
     case AMT_C_U8_CCAMSG_OPCODE_ERROR:
     {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnPerformVolLimit,received with AMT_C_U8_CCAMSG_OPCODE_ERROR opcodes ");
      break;
     }
     default:
     {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnPerformVolLimit,received with unknown opcodes ");
      break;
     }
    }
   }
   else
   {
    log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnPerformVolLimit,poMessage == OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnBassStatus
 *DESCRIPTION  : callback for property Bass
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnBassStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnBassStatus");
   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgBassStatus oBassMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oBassMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus received Status,Bass:",oBassMessageStatus.Bass,
               ",Resource:",oBassMessageStatus.Resource.enType,",Channel",oBassMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_BASS == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus->Status  received,Inserting Bass Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus->Status  received,Ignoring Bass Response...");
            }

            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus,received with AMT_C_U8_CCAMSG_OPCODE_ERROR opcodes ");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus,received with unknown opcodes ");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBassStatus,poMessage == OSAL_NULL ");
   }
}
/************************************************************************
 *FUNCTION     : vOnTrebleStatus
 *DESCRIPTION  : Callback method for property Treble
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnTrebleStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vOnTrebleStatus");
   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTrebleStatus,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTrebleStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgTrebleStatus oTrebleMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oTrebleMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTrebleStatus received Status,treble:",oTrebleMessageStatus.Treble,
               ",Resource:",oTrebleMessageStatus.Resource.enType,",Channel",oTrebleMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_TREBLE == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTrebleStatus->Status  received,Inserting treble Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTrebleStatus->Status  received,Ignoring treble Response....");
            }
            break;
         }
      case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTreble,received with AMT_C_U8_CCAMSG_OPCODE_ERROR opcodes ");
            break;
         }
      default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTreble,received with Unknown opcodes ");
            break;
         }
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnTreble,poMessage == OSAL_NUL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnMidRangeStatus
 *DESCRIPTION  : callback for property MidRange
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnMidRangeStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus called");
   if ( poMessage != OSAL_NULL )
   {
      switch(poMessage->u8GetOpCode())
      {
         //You can add multiple cases for all the opcodes that you are interested in
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus,received with AMT_C_U8_CCAMSG_OPCODE_METHODRESULT opcodes ");

            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgMidRangeStatus oMidRangeMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oMidRangeMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus received Status,MidRange:",oMidRangeMessageStatus.MidRange,
               ",Resource:",oMidRangeMessageStatus.Resource.enType,",Channel",oMidRangeMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_MIDRANGE == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus->Status  received,Inserting MidRange Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus->Status  received,Ignoring MidRange Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMidRangeStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnLoudnessStatus
 *DESCRIPTION  : Callback method for property Loudness
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnLoudnessStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgLoudnessStatus oLoudnessMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oLoudnessMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus received Status,Loudness:",oLoudnessMessageStatus.Loudness,
               ",Resource:",oLoudnessMessageStatus.Resource.enType,",Channel",oLoudnessMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_LOUDNESS == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus->Status  received,Inserting Loudness Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus->Status  received,Ignoring Loudness Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLoudnessStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnBalanceStatus
 *DESCRIPTION  : Callback method for property Balance
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnBalanceStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgBalanceStatus oBalanceMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oBalanceMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus received Status,Balance:",oBalanceMessageStatus.Balance,
               ",Resource:",oBalanceMessageStatus.Resource.enType,",Channel",oBalanceMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_BALANCE == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus->Status  received,Inserting Balance Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus->Status  received,Ignoring Balance Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBalanceStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnFaderStatus
 *DESCRIPTION  : Callback method for property Fader
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnFaderStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgFaderStatus oFaderMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oFaderMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus received Status,Fader:",oFaderMessageStatus.Fader,
               ",Resource:",oFaderMessageStatus.Resource.enType,",Channel",oFaderMessageStatus.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_FADER == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus->Status  received,Inserting Fader Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus->Status  received,Ignoring Fader Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnDynamicCompressionStatus
 *DESCRIPTION  : Callback method for property DynamicCompression
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnDynamicCompressionStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgDynamicCompressionStatus oDynCompressionMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oDynCompressionMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus received Status,DynCompression:",oDynCompressionMessageStatus.DynCompression.enType,
               ",Resource:",oDynCompressionMessageStatus.Resource.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_DYNA_COMPRESSION == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus->Status  received,Inserting DynamicCompression Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus->Status  received,Ignoring DynamicCompression Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnDynamicCompressionStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderStatus,poMessage=OSAL_NULL ");
   }
}
/************************************************************************
 *FUNCTION     : vOnEquPresetStatus
 *DESCRIPTION  : Callback method for property EquPreset
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnEquPresetStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgEqualiserPresetStatus oEquPresetMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oEquPresetMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus received Status,EquPreset:",oEquPresetMessageStatus.EquPreset.enType,
               ",Resource:",oEquPresetMessageStatus.Resource.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_EQU_PRESET == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus->Status  received,Inserting EquPreset Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus->Status  received,Ignoring EquPreset Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnEquPresetStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnSpeedDepVolumeStatus
 *DESCRIPTION  : Callback method for property GalaLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnSpeedDepVolumeStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgGalaStatus oGalaMessageStatus;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oGalaMessageStatus);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus received Status,GalaLevel:",oGalaMessageStatus.GalaLevel.enType,
               ",Resource:",oGalaMessageStatus.Resource.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_SDVC == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus->Status  received,Inserting GalaLevel Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus->Status  received,Ignoring GalaLevel Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSpeedDepVolumeStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnMicConnectionStatus
 *DESCRIPTION  : Callback method for property MicrophoneConnectionStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnMicConnectionStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgMicrophoneConnectionStatusStatus oMicConnStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oMicConnStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus received Status,u16MicrophoneCurrent:",oMicConnStatusMessage.u16MicrophoneCurrent,
               ",e8MicrophoneConnectionStatus:",oMicConnStatusMessage.e8MicrophoneConnectionStatus.enType);

            if(m_pControlReceiverShadowInterface)
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus->Status  received,Inserting MicConnStatus Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus->Status  received,Ignoring MicConnStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnMicConnectionStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnSoundOptimizationStatus
 *DESCRIPTION  : Callback method for property SoundOptimizationStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnSoundOptimizationStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgOptimizationStatus oSndProOptStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oSndProOptStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus received Status,Optimization:",oSndProOptStatusMessage.Optimization.enType,
               ",Resource:",oSndProOptStatusMessage.Resource.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_SND_OPTIMIZATION == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
              log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus->Status  received,Inserting SndPropOptimizationStatus Response");
              m_pControlReceiverShadowInterface->insert_queue(poMessage);
              m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus->Status  received,Ignoring SndPropOptimizationStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundOptimizationStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnSoundRoomEffectStatus
 *DESCRIPTION  : Callback method for property SoundOptimizationStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnSoundRoomEffectStatus(amt_tclServiceData* poMessage) const
{
   (void) poMessage;
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSoundRoomEffectStatus called");
}
/************************************************************************
 *FUNCTION     : vOnLevelAuxInStatus
 *DESCRIPTION  : Callback method for property AuxInLevel
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnLevelAuxInStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgAuxInLevelStatus oAuxInLevelStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oAuxInLevelStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus received Status,AuxInLevel:",oAuxInLevelStatusMessage.AuxInLevel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_AUX == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus->Status received,Inserting AuxInStatus Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus->Status  received,Ignoring AuxInStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelAuxInStatus,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnBeep
 *DESCRIPTION  : Callback method for Method Beep
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnBeep(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep,opcode : AMT_C_U8_CCAMSG_OPCODE_METHODRESULT");
            midw_mascffi_tclMsgBeepMethodResult oBeepMethodResult;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oBeepMethodResult);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep ,ServiceStatus:",oBeepMethodResult.ServiceStatus.enType);

            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnBeep,poMessage=OSAL_NULL ");
   }
}

/************************************************************************
 *FUNCTION     : vOnLevelBeepStatus
 *DESCRIPTION  : Callback method for property Beep
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnLevelBeepStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgBeepStatusStatus oBeepStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oBeepStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus received Status,BeepStatus:",oBeepStatusMessage.BeepStatus.enType,
               ",Resource:",oBeepStatusMessage.Resource.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_MSP_BEEP_LEVEL == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus->Status received,Inserting BeepStatus Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus->Status  received,Ignoring BeepStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelBeepStatus,poMessage=OSAL_NULL ");
   }
}
/************************************************************************
 *FUNCTION     : vOnVolumeModeStatus
 *DESCRIPTION  : Callback method for property VolumeModeStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnVolumeModeStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgVolumeModeStatusStatus oVolumeModeStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oVolumeModeStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus received Status,VolumeMode:",oVolumeModeStatusMessage.VolumeMode.enType,
               ",Resource:",oVolumeModeStatusMessage.Resource.enType,",Channel:",oVolumeModeStatusMessage.Channel.enType);

            if((m_pControlReceiverShadowInterface)&&
                  (REQUEST_SYP_VOL_MODE == m_pControlReceiverShadowInterface->enRequestType)
               )
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus->Status received,Inserting VolumeModeStatus Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus->Status  received,Ignoring VolumeModeStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnVolumeModeStatus,poMessage=OSAL_NULL ");
   }
}

void amcontrol_clienthandler_fc_audiomanager::vOnLevelCenterStatus(amt_tclServiceData* poMessage) const
{
   (void) poMessage;
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelCenterStatus called");
}

void amcontrol_clienthandler_fc_audiomanager::vOnLevelSubWooferStatus(amt_tclServiceData* poMessage) const
{
   (void) poMessage;
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnLevelSubWooferStatus called");
}

void amcontrol_clienthandler_fc_audiomanager::vOnSettingSurroundStatus(amt_tclServiceData* poMessage) const
{
   (void) poMessage;
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnSettingSurroundStatus called");
}

/************************************************************************
 *FUNCTION     : vOnFaderActiveStatus
 *DESCRIPTION  : Callback method for property FaderActiveStatus
 *PARAMETER    : amt_tclServiceData*
 *RETURN VALUE : void
 *HISTORY      :
 *12.09.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
void amcontrol_clienthandler_fc_audiomanager::vOnFaderActiveStatus(amt_tclServiceData* poMessage)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus called");
   if(poMessage != OSAL_NULL)
   {
      switch(poMessage->u8GetOpCode())
      {
         case AMT_C_U8_CCAMSG_OPCODE_STATUS:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus,received with AMT_C_U8_CCAMSG_OPCODE_STATUS opcodes ");
            midw_mascffi_tclMsgFaderActivationStatusStatus oFaderActStatusMessage;

            //Get the data using Helper function
            vCopyDatatoFIMessage(poMessage,oFaderActStatusMessage);

            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus received Status,FaderStatus:",oFaderActStatusMessage.FaderStatus.enType);

            if(m_pControlReceiverShadowInterface)
            {
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus->Status received,Inserting FaderActiveStatus Response");
               m_pControlReceiverShadowInterface->insert_queue(poMessage);
               m_pControlReceiverShadowInterface->vSwitchThreadContext<CAmControlSenderBase>(m_pControlSenderBase, &CAmControlSenderBase::cbAckCCAMessageReceived);
            }
            else{
               log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus->Status  received,Ignoring FaderActiveStatus Response...");
            }
            break;
         }
         case AMT_C_U8_CCAMSG_OPCODE_ERROR:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus,received with opcodes AMT_C_U8_CCAMSG_OPCODE_ERROR");
            break;
         }
         default:
         {
            log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus,received with Unknown opcodes ");
            break;
         }
      }//Switch
   }//If
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vOnFaderActiveStatus,poMessage=OSAL_NULL ");
   }
}
/*******************************************************************************
               Methods of this application
*******************************************************************************/

/************************************************************************
 *FUNCTION     : vSetVolume
 *DESCRIPTION  : Function to post CCAMessage to setVolume
 *PARAMETER    : uint8_t u8VolumeType,uint8_t u8Resource,uint8_t u8Volume
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetVolume(uint8_t u8VolumeType,uint8_t u8Resource,uint8_t u8Volume)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetVolume called,u8VolumeType:",u8VolumeType,"u8Resource:",u8Resource,"u8Volume:",u8Volume);
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      midw_mascffi_tclMsgVolumeSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.VolumeType.enType = (midw_fi_tcl_e8_AudioVolumeType::tenType) u8VolumeType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Volume = u8Volume;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_VOLUME,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetVolume called,enPostMessage() failed..");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetVolume:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetVolume called,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSystemSoundProperty_VolumeMode
 *DESCRIPTION  : Function to post CCAMessage to setVolumeMode
 *PARAMETER    : uint8_t u8VolumeMode,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_VolumeMode(uint8_t u8VolumeMode,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"entered in vSetSystemSoundProperty_VolumeMode,u8VolumeMode:",u8VolumeMode);
   if( true == bIfServiceAvailable() )
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_VolumeMode:Service Available");
      midw_mascffi_tclMsgVolumeModeMethodStart oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.VolumeMode.enType = (midw_fi_tcl_e8_VolumeMode::tenType) u8VolumeMode;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_VOLUMEMODE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_VolumeMode:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_VolumeMode:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_VolumeMode,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetMute
 *DESCRIPTION  : Function to post CCAMessage to setMute
 *PARAMETER    : uint8_t ,uint8_t ,uint8_t ,uint8_t ,uint8_t
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetMute(uint8_t u8MuteRequester,uint8_t u8Resource,uint8_t u8MuteAction,uint8_t u8MuteReason,uint8_t u8Channel)
{
   (void)u8MuteReason;
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetMute");
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgMuteMethodStart oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.Requester.enType = (midw_fi_tcl_e8_MuteRequester::tenType) u8MuteRequester;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.State.enType = (midw_fi_tcl_e8MuteAction::tenType) u8MuteAction;
      oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);

      //TODO -
      /*switch(u8MuteReason)
      {
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_USER_ACTION:
            oFiDataObject1.Reason.vSetMUTE_REAS_USER_ACTION(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_START_OF_TRACK:
            oFiDataObject1.Reason.vSetMUTE_REAS_START_OF_TRACK(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_SOURCE_SEL:
            oFiDataObject1.Reason.vSetMUTE_REAS_SOURCE_SEL(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_DIAG:
            oFiDataObject1.Reason.vSetMUTE_REAS_DIAG(true);
            break;
         case oFiDataObject1.Reason.FI_C_U32_BIT_MUTE_REAS_OTHER:
            oFiDataObject1.Reason.vSetMUTE_REAS_OTHER(true);
            break;
         default:
            break;
      }*/

      //oFiDataObject1.Reason.bMUTE_REAS_USER_ACTION =  u8MuteReason;
      oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_MUTE,
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetMute:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetMute:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetMute,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Bass
 *DESCRIPTION  : Function to post CCAMessage to SetBass property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Bass
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Bass(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Bass)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_Bass,u8Bass:",i8Bass);

   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgBassSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Bass = i8Bass;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_BASS,
            AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Bass:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Bass:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Bass,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Treble
 *DESCRIPTION  : Function to post CCAMessage to Set Treble property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Treble
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Treble(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Treble)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_Treble, i8Treble:",i8Treble);
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgTrebleSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Treble = i8Treble;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_TREBLE,
            AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Treble:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Treble:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Treble,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_MidRange
 *DESCRIPTION  : Function to post CCAMessage to Set MidRange property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8MidRange
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_MidRange(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8MidRange)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_MidRange,i8MidRange:",i8MidRange);
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgMidRangeSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.MidRange = i8MidRange;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_MIDRANGE,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_MidRange:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_MidRange:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_MidRange,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Loudness
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Loudness(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Loudness)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_Loudness,i8Loudness:",i8Loudness);
   // Check if Service of server is available
   if(bIfServiceAvailable())
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgLoudnessSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Loudness = i8Loudness;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_LOUDNESS,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Loudness:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Loudness:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Loudness,Service is not available:");
   }
}


/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Balance
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Balance(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Balance)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_Balance,i8Balance:",i8Balance);
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgBalanceSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Balance = i8Balance;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_BALANCE,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Balance:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Balance:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Balance,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_Fader
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_Fader(uint8_t u8SoundType,uint8_t u8Resource,int8_t i8Fader)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_Fader,i8Fader:",i8Fader);
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgFaderSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.SoundType.enType = (midw_fi_tcl_e8_AudioSoundType::tenType) u8SoundType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Fader = i8Fader;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_FADER,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Fader:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Fader:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_Fader,Service is not available:");
   }
}


/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_DynCompression
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_DynCompression(uint8_t u8DynComp,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_DynCompression");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgDynamicCompressionSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.DynComp.enType = (midw_fi_tcl_e8_DynCompression::tenType) u8DynComp;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_DYNAMICCOMPRESSION,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_DynCompression:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_DynCompression:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_DynCompression,Service is not available:");
   }
}


/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_PresetEquilizer
 *DESCRIPTION  : Function to post CCAMessage to Set Loudness property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_PresetEquilizer(uint8_t u8EquPresets,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_PresetEquilizer");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgEqualiserPresetSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.EquPreset.enType = (midw_fi_tcl_e8_EquPresets::tenType) u8EquPresets;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_EQUALISERPRESET,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_PresetEquilizer:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_PresetEquilizer:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_PresetEquilizer,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_SpeedDepVolChange
 *DESCRIPTION  : Function to post CCAMessage to Set (SDVC/Gala) property
 *PARAMETER    : uint8_t u8SoundType,uint8_t u8Resource,uint8_t u8Loudness
 *RETURN VALUE : tVoid
 *HISTORY         :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SpeedDepVolChange(uint8_t u8GalaLevel,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_SpeedDepVolChange,u8GalaLevel :",u8GalaLevel);
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgGalaSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.GalaLevel.enType = (midw_fi_tcl_e8_GalaLevel::tenType) u8GalaLevel;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_GALA,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SpeedDepVolChange:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SpeedDepVolChange:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SpeedDepVolChange,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSinkSoundProperty_SoundOptimization
 *DESCRIPTION  : Function to post CCAMessage to Set Sound optimization property
 *PARAMETER    : uint8_t u8Optimization,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSinkSoundProperty_SoundOptimization(uint8_t u8Optimization,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSinkSoundProperty_SoundOptimization");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgOptimizationSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.Optimization.enType = (midw_fi_tcl_e8_Optimization::tenType) u8Optimization;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_OPTIMIZATION,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SoundOptimization:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SoundOptimization:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSinkSoundProperty_SoundOptimization,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSourceSoundProperty_AuxInLevel
 *DESCRIPTION  : Function to post CCAMessage to Set AuxInLevel property
 *PARAMETER    : uint8_t u8AuxInLevel
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSourceSoundProperty_AuxInLevel(uint8_t u8AuxInLevel)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSourceSoundProperty_AuxInLevel");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgAuxInLevelSet oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.AuxInLevel.enType = (midw_fi_tcl_e8_AuxInLevel::tenType) u8AuxInLevel;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_AUXINLEVEL,
         AMT_C_U8_CCAMSG_OPCODE_SET, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSourceSoundProperty_AuxInLevel:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSourceSoundProperty_AuxInLevel:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSourceSoundProperty_AuxInLevel,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vSetSourceSoundProperty_Beep
 *DESCRIPTION  : Function to post CCAMessage to Set Beep Sound property
 *PARAMETER    : uint8_t u8BeepType,uint8_t u8Resource
 *RETURN VALUE : tVoid
 *HISTORY      :
 *18.06.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetSystemSoundProperty_Beep(uint8_t u8BeepType,uint8_t u8Resource)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetSystemSoundProperty_Beep");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgBeepMethodStart oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.BeepType.enType = (midw_fi_tcl_e8_AudioBeepType::tenType) u8BeepType;
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_BEEP,
            AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_Beep:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_Beep:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetSystemSoundProperty_Beep,Service is not available:");
   }
}

/************************************************************************
 *FUNCTION     : vPerformOnVolLimit
 *DESCRIPTION  : Function to post CCAMessage to start method OnVolLimit
 *PARAMETER    : NA
 *RETURN VALUE : tVoid
 *HISTORY      :
 *22.10.2013   Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vPerformOnVolLimit()
{
  log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vPerformOnVolLimit");
  // Check if Service of server is available
  if( bIfServiceAvailable() )
  {
    // Create the (message related) FI data object
    midw_mascffi_tclMsgPerformOnVolumeLimitMethodStart oFiDataObject1;

    bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_PERFORMONVOLUMELIMIT,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

    if (enResult != true)
    {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vPerformOnVolLimit:Failed to PostMessage");
    }
    else
    {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vPerformOnVolLimit:bPostFIMessage returned successfully");
    }
  }
  else
  {
    log(&ClientFCAudioMgr,DLT_LOG_INFO,"vPerformOnVolLimit,Service is not available:");
  }
}

/************************************************************************
* FUNCTION     : vSetAmpDeviceAudioRoute
* DESCRIPTION  : function to set am device audio route
*
* PARAMETER    : uint8_t u8Resource,uint8_t u8Channel,uint8_t u8Source
* RETURNVALUE  : tVoid
* HISTORY      :
* 10.09.12 Vyankatesh VD   Initial Revision.
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetAmpDeviceAudioRoute(uint8_t u8Resource,uint8_t u8Channel,uint8_t u8Source)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetAmpDeviceAudioRoute");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgAmpDeviceAudioRouteMethodStart oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;
      oFiDataObject1.Source.enType = (midw_fi_tcl_e8_RouteNo::tenType) u8Source;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_AMPDEVICEAUDIOROUTE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAmpDeviceAudioRoute:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAmpDeviceAudioRoute:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAmpDeviceAudioRoute,Service is not available:");
   }
}

/************************************************************************
* FUNCTION     : vSetAudioSource
* DESCRIPTION  : function to set audio source
*
* PARAMETER    : uint8_t u8Resource,uint8_t u8Source,uint8_t u8Channel
* RETURNVALUE  : tVoid
* HISTORY      :
*              10.09.12 Vyankatesh VD  Initial Revision.
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vSetAudioSource(uint8_t u8Resource,uint8_t u8Source,uint8_t u8Channel)
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered vSetAudioSource");
   // Check if Service of server is available
   if( bIfServiceAvailable() )
   {
      // Create the (message related) FI data object
      midw_mascffi_tclMsgAudioSourceMethodStart oFiDataObject1;

      //Fill the parameters into the (message related) FI data object.
      oFiDataObject1.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType) u8Resource;
      oFiDataObject1.Source.enType = (midw_fi_tcl_e8_AudSource::tenType) u8Source;
      oFiDataObject1.Channel.enType = (midw_fi_tcl_e8_AudioChannel::tenType) u8Channel;;

      bool enResult = bPostFIMessage(MIDW_MASCFFI_C_U16_AUDIOSOURCE,
         AMT_C_U8_CCAMSG_OPCODE_METHODSTART, oFiDataObject1);

      if (enResult != true)
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAudioSource:Failed to PostMessage");
      }
      else
      {
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAudioSource:bPostFIMessage returned successfully");
      }
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"vSetAudioSource,Service is not available:");
   }
}

/************************************************************************
* FUNCTION     : vOnServiceAvailable
* DESCRIPTION  : Callback function to get status tha fc_audiomanager
*             service is available
* PARAMETER    : void
* RETURNVALUE  : tVoid
* HISTORY      :
*              10.09.12 Vyankatesh VD  Initial Revision.
************************************************************************/
tVoid amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable()
{
   log(&ClientFCAudioMgr,DLT_LOG_INFO,"Entered in amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable");
   if(m_pControlReceiverShadowInterface)
   {
      if(false == m_pControlReceiverShadowInterface->m_bServiceReady_fcAudioMgr)
      {
         m_pControlReceiverShadowInterface->m_bServiceReady_fcAudioMgr = true;
      }
   }

   if(m_pControlReceiverShadowInterface)
   {
      if((false == m_pControlReceiverShadowInterface->m_bControllerReady) &&
            (true == m_pControlReceiverShadowInterface->m_bServiceReady_fcAudioRouteMgr) &&
               (true == m_pControlReceiverShadowInterface->m_bRoutingReady))
      {
         m_pControlReceiverShadowInterface->m_bControllerReady = true;
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable,Calling confirmControllerReady");
         m_pControlReceiverShadowInterface->confirmControllerReady(E_OK);

         //log(&ClientFCAudioMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable,Connecting to default source FM...");
         //am_mainConnectionID_t mainConnectionID;
         //m_pControlSenderBase->hookUserConnectionRequest(1, 1, mainConnectionID);
         m_pControlSenderBase->InitStackManager();
      }
      else
         log(&ClientFCAudioMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable,already sent confirmControllerReady OR \
            waiting for serivice fcAudioRouteMgr..OR waiting for confirmRoutingReady");
   }
   else
   {
      log(&ClientFCAudioMgr,DLT_LOG_INFO,"amcontrol_clienthandler_fc_audiomanager::vOnServiceAvailable, m_pReceiverShadowInterface is NULL");
   }
}
/**
* wrapper function to copy the data from a FI Message to amt_tclServiceData
*/
void amcontrol_clienthandler_fc_audiomanager::vCopyDatatoFIMessageWrapper(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData)
{
   //Get the data using Helper function
   vCopyDatatoFIMessage(poFIMsg,oFIData);
}
